/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

public class VWUrlEncodingUtils {
    private static final int LAST_6_BITS_MASK = 63;
    private static final char ESCAPE_CHARACTER = '.';
    private static final char PATH_ESCAPE_CHARACTER = '*';
    private static final char[] BASE_64_DIGITS = "_ABCDEFGHIJKLMNOPQRSTUVWXYZabcde.fghijklmnopqrstuvwxyz0123456789".toCharArray();
    private static final int[] DECODE_TABLE_64 = new int[128];

    public static String encodeLabel(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if ('a' <= ch && ch <= 'z') {
                sb.append(ch);
                continue;
            }
            if ('A' <= ch && ch <= 'Z') {
                sb.append(ch);
                continue;
            }
            if ('0' <= ch && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (ch == '*' || ch == '-' || ch == '_') {
                sb.append(ch);
                continue;
            }
            sb.append('.');
            sb.append(BASE_64_DIGITS[ch >> 12]);
            sb.append(BASE_64_DIGITS[ch >> 6 & 0x3F]);
            sb.append(BASE_64_DIGITS[ch & 0x3F]);
        }
        return sb.toString();
    }

    public static String decodeLabel(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] source = str.toCharArray();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = source[i];
            if (ch == '.') {
                int d3 = DECODE_TABLE_64[source[++i]] << 12;
                int d2 = DECODE_TABLE_64[source[++i]] << 6;
                int d1 = DECODE_TABLE_64[source[++i]];
                sb.append((char)(d1 + d2 + d3));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

